<?php

namespace Unicamp_Addons;

/**
 * Countries
 *
 * Returns an array of countries and codes.
 * Country codes and names should follow the Unicode CLDR recommendation (http://cldr.unicode.org/translation/country-names).
 */

defined( 'ABSPATH' ) || exit;

class I18l_Countries {
	public static function get_list() {
		return array(
			'AF' => __( 'Afghanistan', 'unicamp-addons' ),
			'AX' => __( '&#197;land Islands', 'unicamp-addons' ),
			'AL' => __( 'Albania', 'unicamp-addons' ),
			'DZ' => __( 'Algeria', 'unicamp-addons' ),
			'AS' => __( 'American Samoa', 'unicamp-addons' ),
			'AD' => __( 'Andorra', 'unicamp-addons' ),
			'AO' => __( 'Angola', 'unicamp-addons' ),
			'AI' => __( 'Anguilla', 'unicamp-addons' ),
			'AQ' => __( 'Antarctica', 'unicamp-addons' ),
			'AG' => __( 'Antigua and Barbuda', 'unicamp-addons' ),
			'AR' => __( 'Argentina', 'unicamp-addons' ),
			'AM' => __( 'Armenia', 'unicamp-addons' ),
			'AW' => __( 'Aruba', 'unicamp-addons' ),
			'AU' => __( 'Australia', 'unicamp-addons' ),
			'AT' => __( 'Austria', 'unicamp-addons' ),
			'AZ' => __( 'Azerbaijan', 'unicamp-addons' ),
			'BS' => __( 'Bahamas', 'unicamp-addons' ),
			'BH' => __( 'Bahrain', 'unicamp-addons' ),
			'BD' => __( 'Bangladesh', 'unicamp-addons' ),
			'BB' => __( 'Barbados', 'unicamp-addons' ),
			'BY' => __( 'Belarus', 'unicamp-addons' ),
			'BE' => __( 'Belgium', 'unicamp-addons' ),
			'PW' => __( 'Belau', 'unicamp-addons' ),
			'BZ' => __( 'Belize', 'unicamp-addons' ),
			'BJ' => __( 'Benin', 'unicamp-addons' ),
			'BM' => __( 'Bermuda', 'unicamp-addons' ),
			'BT' => __( 'Bhutan', 'unicamp-addons' ),
			'BO' => __( 'Bolivia', 'unicamp-addons' ),
			'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'unicamp-addons' ),
			'BA' => __( 'Bosnia and Herzegovina', 'unicamp-addons' ),
			'BW' => __( 'Botswana', 'unicamp-addons' ),
			'BV' => __( 'Bouvet Island', 'unicamp-addons' ),
			'BR' => __( 'Brazil', 'unicamp-addons' ),
			'IO' => __( 'British Indian Ocean Territory', 'unicamp-addons' ),
			'BN' => __( 'Brunei', 'unicamp-addons' ),
			'BG' => __( 'Bulgaria', 'unicamp-addons' ),
			'BF' => __( 'Burkina Faso', 'unicamp-addons' ),
			'BI' => __( 'Burundi', 'unicamp-addons' ),
			'KH' => __( 'Cambodia', 'unicamp-addons' ),
			'CM' => __( 'Cameroon', 'unicamp-addons' ),
			'CA' => __( 'Canada', 'unicamp-addons' ),
			'CV' => __( 'Cape Verde', 'unicamp-addons' ),
			'KY' => __( 'Cayman Islands', 'unicamp-addons' ),
			'CF' => __( 'Central African Republic', 'unicamp-addons' ),
			'TD' => __( 'Chad', 'unicamp-addons' ),
			'CL' => __( 'Chile', 'unicamp-addons' ),
			'CN' => __( 'China', 'unicamp-addons' ),
			'CX' => __( 'Christmas Island', 'unicamp-addons' ),
			'CC' => __( 'Cocos (Keeling) Islands', 'unicamp-addons' ),
			'CO' => __( 'Colombia', 'unicamp-addons' ),
			'KM' => __( 'Comoros', 'unicamp-addons' ),
			'CG' => __( 'Congo (Brazzaville)', 'unicamp-addons' ),
			'CD' => __( 'Congo (Kinshasa)', 'unicamp-addons' ),
			'CK' => __( 'Cook Islands', 'unicamp-addons' ),
			'CR' => __( 'Costa Rica', 'unicamp-addons' ),
			'HR' => __( 'Croatia', 'unicamp-addons' ),
			'CU' => __( 'Cuba', 'unicamp-addons' ),
			'CW' => __( 'Cura&ccedil;ao', 'unicamp-addons' ),
			'CY' => __( 'Cyprus', 'unicamp-addons' ),
			'CZ' => __( 'Czech Republic', 'unicamp-addons' ),
			'DK' => __( 'Denmark', 'unicamp-addons' ),
			'DJ' => __( 'Djibouti', 'unicamp-addons' ),
			'DM' => __( 'Dominica', 'unicamp-addons' ),
			'DO' => __( 'Dominican Republic', 'unicamp-addons' ),
			'EC' => __( 'Ecuador', 'unicamp-addons' ),
			'EG' => __( 'Egypt', 'unicamp-addons' ),
			'SV' => __( 'El Salvador', 'unicamp-addons' ),
			'GQ' => __( 'Equatorial Guinea', 'unicamp-addons' ),
			'ER' => __( 'Eritrea', 'unicamp-addons' ),
			'EE' => __( 'Estonia', 'unicamp-addons' ),
			'ET' => __( 'Ethiopia', 'unicamp-addons' ),
			'FK' => __( 'Falkland Islands', 'unicamp-addons' ),
			'FO' => __( 'Faroe Islands', 'unicamp-addons' ),
			'FJ' => __( 'Fiji', 'unicamp-addons' ),
			'FI' => __( 'Finland', 'unicamp-addons' ),
			'FR' => __( 'France', 'unicamp-addons' ),
			'GF' => __( 'French Guiana', 'unicamp-addons' ),
			'PF' => __( 'French Polynesia', 'unicamp-addons' ),
			'TF' => __( 'French Southern Territories', 'unicamp-addons' ),
			'GA' => __( 'Gabon', 'unicamp-addons' ),
			'GM' => __( 'Gambia', 'unicamp-addons' ),
			'GE' => __( 'Georgia', 'unicamp-addons' ),
			'DE' => __( 'Germany', 'unicamp-addons' ),
			'GH' => __( 'Ghana', 'unicamp-addons' ),
			'GI' => __( 'Gibraltar', 'unicamp-addons' ),
			'GR' => __( 'Greece', 'unicamp-addons' ),
			'GL' => __( 'Greenland', 'unicamp-addons' ),
			'GD' => __( 'Grenada', 'unicamp-addons' ),
			'GP' => __( 'Guadeloupe', 'unicamp-addons' ),
			'GU' => __( 'Guam', 'unicamp-addons' ),
			'GT' => __( 'Guatemala', 'unicamp-addons' ),
			'GG' => __( 'Guernsey', 'unicamp-addons' ),
			'GN' => __( 'Guinea', 'unicamp-addons' ),
			'GW' => __( 'Guinea-Bissau', 'unicamp-addons' ),
			'GY' => __( 'Guyana', 'unicamp-addons' ),
			'HT' => __( 'Haiti', 'unicamp-addons' ),
			'HM' => __( 'Heard Island and McDonald Islands', 'unicamp-addons' ),
			'HN' => __( 'Honduras', 'unicamp-addons' ),
			'HK' => __( 'Hong Kong', 'unicamp-addons' ),
			'HU' => __( 'Hungary', 'unicamp-addons' ),
			'IS' => __( 'Iceland', 'unicamp-addons' ),
			'IN' => __( 'India', 'unicamp-addons' ),
			'ID' => __( 'Indonesia', 'unicamp-addons' ),
			'IR' => __( 'Iran', 'unicamp-addons' ),
			'IQ' => __( 'Iraq', 'unicamp-addons' ),
			'IE' => __( 'Ireland', 'unicamp-addons' ),
			'IM' => __( 'Isle of Man', 'unicamp-addons' ),
			'IL' => __( 'Israel', 'unicamp-addons' ),
			'IT' => __( 'Italy', 'unicamp-addons' ),
			'CI' => __( 'Ivory Coast', 'unicamp-addons' ),
			'JM' => __( 'Jamaica', 'unicamp-addons' ),
			'JP' => __( 'Japan', 'unicamp-addons' ),
			'JE' => __( 'Jersey', 'unicamp-addons' ),
			'JO' => __( 'Jordan', 'unicamp-addons' ),
			'KZ' => __( 'Kazakhstan', 'unicamp-addons' ),
			'KE' => __( 'Kenya', 'unicamp-addons' ),
			'KI' => __( 'Kiribati', 'unicamp-addons' ),
			'KW' => __( 'Kuwait', 'unicamp-addons' ),
			'KG' => __( 'Kyrgyzstan', 'unicamp-addons' ),
			'LA' => __( 'Laos', 'unicamp-addons' ),
			'LV' => __( 'Latvia', 'unicamp-addons' ),
			'LB' => __( 'Lebanon', 'unicamp-addons' ),
			'LS' => __( 'Lesotho', 'unicamp-addons' ),
			'LR' => __( 'Liberia', 'unicamp-addons' ),
			'LY' => __( 'Libya', 'unicamp-addons' ),
			'LI' => __( 'Liechtenstein', 'unicamp-addons' ),
			'LT' => __( 'Lithuania', 'unicamp-addons' ),
			'LU' => __( 'Luxembourg', 'unicamp-addons' ),
			'MO' => __( 'Macao', 'unicamp-addons' ),
			'MK' => __( 'North Macedonia', 'unicamp-addons' ),
			'MG' => __( 'Madagascar', 'unicamp-addons' ),
			'MW' => __( 'Malawi', 'unicamp-addons' ),
			'MY' => __( 'Malaysia', 'unicamp-addons' ),
			'MV' => __( 'Maldives', 'unicamp-addons' ),
			'ML' => __( 'Mali', 'unicamp-addons' ),
			'MT' => __( 'Malta', 'unicamp-addons' ),
			'MH' => __( 'Marshall Islands', 'unicamp-addons' ),
			'MQ' => __( 'Martinique', 'unicamp-addons' ),
			'MR' => __( 'Mauritania', 'unicamp-addons' ),
			'MU' => __( 'Mauritius', 'unicamp-addons' ),
			'YT' => __( 'Mayotte', 'unicamp-addons' ),
			'MX' => __( 'Mexico', 'unicamp-addons' ),
			'FM' => __( 'Micronesia', 'unicamp-addons' ),
			'MD' => __( 'Moldova', 'unicamp-addons' ),
			'MC' => __( 'Monaco', 'unicamp-addons' ),
			'MN' => __( 'Mongolia', 'unicamp-addons' ),
			'ME' => __( 'Montenegro', 'unicamp-addons' ),
			'MS' => __( 'Montserrat', 'unicamp-addons' ),
			'MA' => __( 'Morocco', 'unicamp-addons' ),
			'MZ' => __( 'Mozambique', 'unicamp-addons' ),
			'MM' => __( 'Myanmar', 'unicamp-addons' ),
			'NA' => __( 'Namibia', 'unicamp-addons' ),
			'NR' => __( 'Nauru', 'unicamp-addons' ),
			'NP' => __( 'Nepal', 'unicamp-addons' ),
			'NL' => __( 'Netherlands', 'unicamp-addons' ),
			'NC' => __( 'New Caledonia', 'unicamp-addons' ),
			'NZ' => __( 'New Zealand', 'unicamp-addons' ),
			'NI' => __( 'Nicaragua', 'unicamp-addons' ),
			'NE' => __( 'Niger', 'unicamp-addons' ),
			'NG' => __( 'Nigeria', 'unicamp-addons' ),
			'NU' => __( 'Niue', 'unicamp-addons' ),
			'NF' => __( 'Norfolk Island', 'unicamp-addons' ),
			'MP' => __( 'Northern Mariana Islands', 'unicamp-addons' ),
			'KP' => __( 'North Korea', 'unicamp-addons' ),
			'NO' => __( 'Norway', 'unicamp-addons' ),
			'OM' => __( 'Oman', 'unicamp-addons' ),
			'PK' => __( 'Pakistan', 'unicamp-addons' ),
			'PS' => __( 'Palestinian Territory', 'unicamp-addons' ),
			'PA' => __( 'Panama', 'unicamp-addons' ),
			'PG' => __( 'Papua New Guinea', 'unicamp-addons' ),
			'PY' => __( 'Paraguay', 'unicamp-addons' ),
			'PE' => __( 'Peru', 'unicamp-addons' ),
			'PH' => __( 'Philippines', 'unicamp-addons' ),
			'PN' => __( 'Pitcairn', 'unicamp-addons' ),
			'PL' => __( 'Poland', 'unicamp-addons' ),
			'PT' => __( 'Portugal', 'unicamp-addons' ),
			'PR' => __( 'Puerto Rico', 'unicamp-addons' ),
			'QA' => __( 'Qatar', 'unicamp-addons' ),
			'RE' => __( 'Reunion', 'unicamp-addons' ),
			'RO' => __( 'Romania', 'unicamp-addons' ),
			'RU' => __( 'Russia', 'unicamp-addons' ),
			'RW' => __( 'Rwanda', 'unicamp-addons' ),
			'BL' => __( 'Saint Barth&eacute;lemy', 'unicamp-addons' ),
			'SH' => __( 'Saint Helena', 'unicamp-addons' ),
			'KN' => __( 'Saint Kitts and Nevis', 'unicamp-addons' ),
			'LC' => __( 'Saint Lucia', 'unicamp-addons' ),
			'MF' => __( 'Saint Martin (French part)', 'unicamp-addons' ),
			'SX' => __( 'Saint Martin (Dutch part)', 'unicamp-addons' ),
			'PM' => __( 'Saint Pierre and Miquelon', 'unicamp-addons' ),
			'VC' => __( 'Saint Vincent and the Grenadines', 'unicamp-addons' ),
			'SM' => __( 'San Marino', 'unicamp-addons' ),
			'ST' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'unicamp-addons' ),
			'SA' => __( 'Saudi Arabia', 'unicamp-addons' ),
			'SN' => __( 'Senegal', 'unicamp-addons' ),
			'RS' => __( 'Serbia', 'unicamp-addons' ),
			'SC' => __( 'Seychelles', 'unicamp-addons' ),
			'SL' => __( 'Sierra Leone', 'unicamp-addons' ),
			'SG' => __( 'Singapore', 'unicamp-addons' ),
			'SK' => __( 'Slovakia', 'unicamp-addons' ),
			'SI' => __( 'Slovenia', 'unicamp-addons' ),
			'SB' => __( 'Solomon Islands', 'unicamp-addons' ),
			'SO' => __( 'Somalia', 'unicamp-addons' ),
			'ZA' => __( 'South Africa', 'unicamp-addons' ),
			'GS' => __( 'South Georgia/Sandwich Islands', 'unicamp-addons' ),
			'KR' => __( 'South Korea', 'unicamp-addons' ),
			'SS' => __( 'South Sudan', 'unicamp-addons' ),
			'ES' => __( 'Spain', 'unicamp-addons' ),
			'LK' => __( 'Sri Lanka', 'unicamp-addons' ),
			'SD' => __( 'Sudan', 'unicamp-addons' ),
			'SR' => __( 'Suriname', 'unicamp-addons' ),
			'SJ' => __( 'Svalbard and Jan Mayen', 'unicamp-addons' ),
			'SZ' => __( 'Swaziland', 'unicamp-addons' ),
			'SE' => __( 'Sweden', 'unicamp-addons' ),
			'CH' => __( 'Switzerland', 'unicamp-addons' ),
			'SY' => __( 'Syria', 'unicamp-addons' ),
			'TW' => __( 'Taiwan', 'unicamp-addons' ),
			'TJ' => __( 'Tajikistan', 'unicamp-addons' ),
			'TZ' => __( 'Tanzania', 'unicamp-addons' ),
			'TH' => __( 'Thailand', 'unicamp-addons' ),
			'TL' => __( 'Timor-Leste', 'unicamp-addons' ),
			'TG' => __( 'Togo', 'unicamp-addons' ),
			'TK' => __( 'Tokelau', 'unicamp-addons' ),
			'TO' => __( 'Tonga', 'unicamp-addons' ),
			'TT' => __( 'Trinidad and Tobago', 'unicamp-addons' ),
			'TN' => __( 'Tunisia', 'unicamp-addons' ),
			'TR' => __( 'Turkey', 'unicamp-addons' ),
			'TM' => __( 'Turkmenistan', 'unicamp-addons' ),
			'TC' => __( 'Turks and Caicos Islands', 'unicamp-addons' ),
			'TV' => __( 'Tuvalu', 'unicamp-addons' ),
			'UG' => __( 'Uganda', 'unicamp-addons' ),
			'UA' => __( 'Ukraine', 'unicamp-addons' ),
			'AE' => __( 'United Arab Emirates', 'unicamp-addons' ),
			'GB' => __( 'United Kingdom (UK)', 'unicamp-addons' ),
			'US' => __( 'United States (US)', 'unicamp-addons' ),
			'UM' => __( 'United States (US) Minor Outlying Islands', 'unicamp-addons' ),
			'UY' => __( 'Uruguay', 'unicamp-addons' ),
			'UZ' => __( 'Uzbekistan', 'unicamp-addons' ),
			'VU' => __( 'Vanuatu', 'unicamp-addons' ),
			'VA' => __( 'Vatican', 'unicamp-addons' ),
			'VE' => __( 'Venezuela', 'unicamp-addons' ),
			'VN' => __( 'Vietnam', 'unicamp-addons' ),
			'VG' => __( 'Virgin Islands (British)', 'unicamp-addons' ),
			'VI' => __( 'Virgin Islands (US)', 'unicamp-addons' ),
			'WF' => __( 'Wallis and Futuna', 'unicamp-addons' ),
			'EH' => __( 'Western Sahara', 'unicamp-addons' ),
			'WS' => __( 'Samoa', 'unicamp-addons' ),
			'YE' => __( 'Yemen', 'unicamp-addons' ),
			'ZM' => __( 'Zambia', 'unicamp-addons' ),
			'ZW' => __( 'Zimbabwe', 'unicamp-addons' ),
		);
	}

	public static function dropdown_list( $args = [] ) {
		$defaults = [
			'name'     => 'country',
			'id'       => 'country',
			'classes'  => 'form-control',
			'selected' => '',
		];

		$args = wp_parse_args( $args, $defaults );

		$countries = self::get_list();
		?>
		<select class="<?php echo esc_attr( $args['classes'] ); ?>" id="<?php echo esc_attr( $args['id'] ) ?>"
		        name="<?php echo esc_attr( $args['name'] ) ?>">
			<?php
			foreach ( $countries as $country_code => $country_name ) {
				?>
				<option
					value="<?php echo $country_code; ?>" <?php selected( $args['selected'], $country_code ); ?>><?php echo esc_html( $country_name ); ?>
				</option>
				<?php
			}
			?>
		</select>
		<?php
	}
}
